/*
 * Decompiled with CFR 0.152.
 */
package Serial;

import java.awt.Toolkit;
import java.util.regex.Pattern;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class MQDocument
extends PlainDocument {
    private static final long serialVersionUID = -4462693078138709956L;
    private String limit = null;
    private int maxLength = -1;
    private double maxValue = 0.0;
    private boolean isMaxValue = false;
    private Toolkit toolkit = null;
    private boolean beep = false;

    public MQDocument() {
        this.init();
    }

    public MQDocument(AbstractDocument.Content c) {
        super(c);
        this.init();
    }

    private void init() {
        this.toolkit = Toolkit.getDefaultToolkit();
    }

    public void setCharLimit(String limit) {
        this.limit = limit;
    }

    public String getCharLimit() {
        return this.limit;
    }

    public void clearLimit() {
        this.limit = null;
    }

    public boolean isOfLimit(CharSequence input) {
        if (this.limit == null) {
            return true;
        }
        return Pattern.compile(this.limit).matcher(input).find();
    }

    public boolean isEmptyLimit() {
        return this.limit == null;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void cancelMaxLength() {
        this.maxLength = -1;
    }

    public void setMaxValue(double maxValue) {
        this.isMaxValue = true;
        this.maxValue = maxValue;
    }

    public boolean isMaxValue() {
        return this.isMaxValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void cancelMaxValue() {
        this.isMaxValue = false;
        this.maxValue = 0.0;
    }

    public void reset() {
        this.clearLimit();
        this.cancelMaxLength();
        this.cancelMaxValue();
    }

    public void errorBeep(boolean beep) {
        this.beep = beep;
    }

    public boolean isErrorBeep() {
        return this.beep;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException, NumberFormatException {
        if (str == null) {
            return;
        }
        boolean b = true;
        char[] ch = str.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            String temp = String.valueOf(ch[i]);
            if (!this.isOfLimit(temp)) {
                b = false;
            }
            if (this.maxLength <= -1 || this.getLength() < this.maxLength) continue;
            b = false;
        }
        if (this.isMaxValue) {
            String s = this.getText(0, this.getLength());
            if (Double.parseDouble(s = s.substring(0, offs) + str + s.substring(offs, s.length())) > this.maxValue) {
                if (this.beep) {
                    this.toolkit.beep();
                }
                return;
            }
        }
        if (!b) {
            if (this.beep) {
                this.toolkit.beep();
            }
            return;
        }
        super.insertString(offs, new String(ch), a);
    }
}

