/*
 * Decompiled with CFR 0.152.
 */
package Serial;

import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

class JTextIPSpace
extends JTextField {
    public int minValue = 0;
    public int maxValue = 255;
    public JTextIPSpace textipspace;
    public boolean bFirstLostFocus = true;
    public boolean isCanFocus = false;
    public JTextField prevComponent;
    public JTextField nextComponent;

    public JTextIPSpace() {
        this(null, 255, false);
    }

    public JTextIPSpace(String str) {
        this(str, 255, true);
    }

    public JTextIPSpace(int maxValue, boolean isCanFocus) {
        this(null, maxValue, isCanFocus);
    }

    public JTextIPSpace(String str, int maxValue, boolean isCanFocus) {
        super(str);
        this.setNoEdge();
        this.setMidHorizontal();
        this.addLostFocus();
        this.addKeySet();
        this.addComponentChange();
        this.textipspace = this;
        this.maxValue = maxValue;
        this.isCanFocus = isCanFocus;
    }

    public void setNoEdge() {
        this.setBorder(null);
        this.setOpaque(true);
    }

    public void setPrevNextComponent(JTextField prev, JTextField next) {
        this.prevComponent = prev;
        this.nextComponent = next;
    }

    private void addComponentChange() {
        ComponentListener cl = new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        };
        this.addComponentListener(cl);
    }

    private void addLostFocus() {
        FocusListener fl = new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                String tmp = JTextIPSpace.this.getText().trim();
                if (tmp.equals("")) {
                    return;
                }
                if (Integer.parseInt(tmp) > JTextIPSpace.this.maxValue && JTextIPSpace.this.bFirstLostFocus) {
                    JTextIPSpace.this.bFirstLostFocus = false;
                    JOptionPane.showConfirmDialog(JTextIPSpace.this.textipspace, tmp + "\u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5\u7684\u9879\u76ee\uff0c\u8bf7\u8f93\u5165" + JTextIPSpace.this.minValue + "\uff5e" + JTextIPSpace.this.maxValue + "\u4e4b\u95f4\u7684\u6570\u503c\uff01", "\u63d0\u793a", -1);
                    JTextIPSpace.this.setText(String.valueOf(JTextIPSpace.this.maxValue));
                    JTextIPSpace.this.requestFocus();
                    JTextIPSpace.this.repaint();
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                JTextIPSpace.this.bFirstLostFocus = true;
                JTextIPSpace.this.repaint();
            }
        };
        this.addFocusListener(fl);
    }

    private void addKeySet() {
        KeyAdapter ka = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int maxPos;
                if (e.getKeyCode() == 37) {
                    int pos = JTextIPSpace.this.getCaretPosition();
                    if (pos == 0) {
                        JTextIPSpace.this.gotoComponent(JTextIPSpace.this.prevComponent);
                    }
                } else if (e.getKeyCode() == 38) {
                    if (JTextIPSpace.this.prevComponent != null) {
                        JTextIPSpace.this.prevComponent.selectAll();
                    }
                    JTextIPSpace.this.gotoComponent(JTextIPSpace.this.prevComponent);
                } else if (e.getKeyCode() == 40) {
                    if (JTextIPSpace.this.nextComponent != null) {
                        JTextIPSpace.this.nextComponent.selectAll();
                    }
                    JTextIPSpace.this.gotoComponent(JTextIPSpace.this.nextComponent);
                } else if (e.getKeyCode() == 39) {
                    int maxPos2;
                    int pos = JTextIPSpace.this.getCaretPosition();
                    if (pos == (maxPos2 = JTextIPSpace.this.getText().trim().length()) || maxPos2 == 0) {
                        JTextIPSpace.this.gotoComponent(JTextIPSpace.this.nextComponent);
                        JTextIPSpace.this.nextComponent.selectAll();
                    }
                } else if (e.getKeyCode() == 8) {
                    int pos = JTextIPSpace.this.getCaretPosition();
                    if (pos == 0) {
                        JTextIPSpace.this.gotoComponent(JTextIPSpace.this.prevComponent);
                        JTextIPSpace.this.nextComponent.selectAll();
                    }
                } else if (e.getKeyChar() == '.' && (maxPos = JTextIPSpace.this.getText().trim().length()) > 0 && JTextIPSpace.this.getSelectedText() == null) {
                    if (JTextIPSpace.this.nextComponent != null) {
                        JTextIPSpace.this.nextComponent.selectAll();
                    }
                    JTextIPSpace.this.gotoComponent(JTextIPSpace.this.nextComponent);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int pos;
                if (Character.isDigit(e.getKeyChar()) && (pos = JTextIPSpace.this.getCaretPosition()) >= 3) {
                    JTextIPSpace.this.nextComponent.selectAll();
                    JTextIPSpace.this.gotoComponent(JTextIPSpace.this.nextComponent);
                }
            }
        };
        this.addKeyListener(ka);
    }

    public void gotoComponent(JComponent jc) {
        if (jc != null) {
            jc.requestFocus();
        }
    }

    public void setMidHorizontal() {
        this.setHorizontalAlignment(0);
    }

    @Override
    protected Document createDefaultModel() {
        return new IPDocument(this);
    }

    protected class IPDocument
    extends PlainDocument {
        public JTextField jtext;

        public IPDocument(JTextField jtext) {
            this.jtext = jtext;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            char[] insertChars = str.toCharArray();
            boolean valid = true;
            if (this.getLength() >= 3) {
                valid = false;
                return;
            }
            int i = 0;
            if (i < Math.min(insertChars.length, 3)) {
                valid = Character.isDigit(insertChars[i]);
            }
            if (valid) {
                super.insertString(offset, str, a);
            }
            if (this.getLength() > 3) {
                super.remove(offset + str.length(), this.getLength() - 2);
            }
        }
    }
}

