/*
 * Decompiled with CFR 0.152.
 */
package Serial;

import Serial.JTextIPSpace;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class IPTextField
extends JTextField {
    private static final int RADII = 2;
    private static final int SPACEINTERVAL = 2;
    private Color DefaultColor_NoSelected = Color.black;
    private Color DefaultColor_Selected = Color.black;
    private String st1 = "0";
    private String st2 = "0";
    private String st3 = "0";
    private String st4 = "1";
    private JTextIPSpace t1;
    private JTextIPSpace t2;
    private JTextIPSpace t3;
    private JTextIPSpace t4;

    public static int isIPaddress(String ipAddress) {
        char tempchar;
        int pointNum = 0;
        int numberNum = 0;
        int numberVal = 0;
        int len = ipAddress.length();
        int m = 0;
        int IPVal = 0;
        while (m < len && ((tempchar = ipAddress.charAt(m)) == ' ' || Character.isDigit(tempchar))) {
            ++m;
            if ('0' <= tempchar && tempchar <= '9') {
                if (numberNum > 2) {
                    return -1;
                }
                numberVal *= 10;
                if ((numberVal += tempchar - 48) > 255) {
                    return -1;
                }
                ++numberNum;
                continue;
            }
            if (numberNum == 0) {
                return -1;
            }
            if (pointNum == 3) {
                return -1;
            }
            ++pointNum;
            IPVal *= 256;
            IPVal += numberVal;
            numberNum = 0;
            numberVal = 0;
        }
        if (m != len || pointNum != 3 || numberNum == 0) {
            return -1;
        }
        ++pointNum;
        IPVal *= 256;
        return IPVal += numberVal;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("IP Field Tester");
        IPTextField ipf = new IPTextField();
        f.getContentPane().add((Component)ipf, "North");
        f.setBounds(200, 300, 200, 160);
        f.setVisible(true);
    }

    public IPTextField() {
        this(false);
    }

    public IPTextField(boolean isSelected) {
        this(isSelected, "");
    }

    public IPTextField(boolean isSelected, Color colorSelect, Color colorNoSelect) {
        this(isSelected, "", colorSelect, colorNoSelect);
    }

    public IPTextField(boolean isSelected, String ipAddress) {
        this(isSelected, "", null, null);
    }

    public IPTextField(boolean isSelected, String ipAddress, Color colorSelect, Color colorNoSelect) {
        this.analyzeStr(ipAddress);
        this.InitIPField();
        this.setChildComponent(false);
        this.setLayout(null);
        this.t1.setPrevNextComponent(this.t4, this.t2);
        this.t2.setPrevNextComponent(this.t1, this.t3);
        this.t3.setPrevNextComponent(this.t2, this.t4);
        this.t4.setPrevNextComponent(this.t3, this.t1);
        this.add(this.t1);
        this.add(this.t2);
        this.add(this.t3);
        this.add(this.t4);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                IPTextField.this.changeChildComponent();
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        this.setChildComponent(true);
        if (colorSelect != null) {
            this.DefaultColor_Selected = colorSelect;
        }
        if (colorNoSelect != null) {
            this.DefaultColor_NoSelected = colorNoSelect;
        }
        this.setSelectEdge(isSelected, this.DefaultColor_Selected, this.DefaultColor_NoSelected);
    }

    public IPTextField(String ipAddress) {
        this(false, ipAddress);
    }

    private void analyzeStr(String str) {
        try {
            StringTokenizer st = new StringTokenizer(str, " ");
            String tk = " ";
            int i = 0;
            while (st.hasMoreTokens() && i <= 3) {
                ++i;
                tk = st.nextToken();
                if (!tk.equals(" ")) {
                    switch (i) {
                        case 1: {
                            this.st1 = tk;
                            break;
                        }
                        case 2: {
                            this.st2 = tk;
                            break;
                        }
                        case 3: {
                            this.st3 = tk;
                            break;
                        }
                        case 4: {
                            this.st4 = tk;
                        }
                    }
                }
                tk = "";
            }
        }
        catch (Exception ex) {
            this.st1 = "";
            this.st2 = "";
            this.st3 = "";
            this.st4 = "";
        }
    }

    private String availIP() {
        String[] strTemp = new String[]{this.t1.getText().trim(), this.t2.getText().trim(), this.t3.getText().trim(), this.t4.getText().trim()};
        String returnIP = "";
        for (int i = 0; i < strTemp.length; ++i) {
            if (strTemp[i].equals("")) continue;
            returnIP = !returnIP.equals("") ? returnIP + " " + strTemp[i] : strTemp[i];
        }
        return returnIP;
    }

    private void changeChildComponent() {
        Dimension sz = this.getSize();
        int spaceWidth = sz.width / 4;
        int spaceHeight = sz.height - 4;
        int r = 2;
        this.t1.setBounds(2, 2, spaceWidth - r, spaceHeight);
        this.t2.setBounds(spaceWidth + r, 2, spaceWidth - r, spaceHeight);
        this.t3.setBounds(2 * spaceWidth + r, 2, spaceWidth - r, spaceHeight);
        this.t4.setBounds(3 * spaceWidth + r, 2, spaceWidth - r - 2, spaceHeight);
        this.repaint();
    }

    public String getIP() {
        return this.availIP();
    }

    public int getIPValue() {
        return IPTextField.isIPaddress(this.getIP());
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = new Dimension(100, 30);
        return dim;
    }

    @Override
    public String getText() {
        return this.getIP();
    }

    private void InitIPField() {
        this.t1 = new JTextIPSpace(this.st1, 255, true);
        this.t2 = new JTextIPSpace(this.st2, 255, true);
        this.t3 = new JTextIPSpace(this.st3, 255, true);
        this.t4 = new JTextIPSpace(this.st4, 255, true);
    }

    @Override
    public void paintComponent(Graphics g) {
        Dimension sz = this.getSize();
        g.setColor(Color.white);
        g.fillRect(0, 0, sz.width, sz.height);
        int spaceWidth = sz.width / 4;
        int spaceHeight = sz.height;
        int r = 2;
        g.setColor(Color.black);
        for (int i = 1; i <= 3; ++i) {
            g.fillOval(i * spaceWidth, spaceHeight - r, r, r);
        }
    }

    private void setChildComponent(boolean isVisible) {
        this.t1.setVisible(isVisible);
        this.t2.setVisible(isVisible);
        this.t3.setVisible(isVisible);
        this.t4.setVisible(isVisible);
        this.repaint();
    }

    public void setIP(String ip) {
        this.setText(ip);
    }

    public void setIPValue(int ip) {
    }

    public void setNoSelected() {
        this.DefaultColor_NoSelected = Color.black;
    }

    public void setNoSelected(Color color) {
        this.DefaultColor_NoSelected = color;
    }

    public void setSelected() {
        this.DefaultColor_Selected = Color.blue;
    }

    public void setSelected(Color color) {
        this.DefaultColor_Selected = color;
    }

    public void setSelectEdge(boolean isSelected, Color selected, Color noSelected) {
        Border border = isSelected ? BorderFactory.createLineBorder(selected.brighter(), 1) : BorderFactory.createLineBorder(noSelected, 1);
        this.setBorder(border);
    }

    @Override
    public void setText(String text) {
        this.st1 = "";
        this.st2 = "";
        this.st3 = "";
        this.st4 = "";
        this.analyzeStr(text);
        this.setTextIPField();
    }

    private void setTextIPField() {
        this.t1.setText(this.st1);
        this.t2.setText(this.st2);
        this.t3.setText(this.st3);
        this.t4.setText(this.st4);
    }
}

