/*
 * Decompiled with CFR 0.152.
 */
package Serial;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class FileHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        BufferedInputStream inBuff = null;
        FilterOutputStream outBuff = null;
        try {
            int len;
            inBuff = new BufferedInputStream(new FileInputStream(sourceFile));
            outBuff = new BufferedOutputStream(new FileOutputStream(targetFile));
            byte[] b = new byte[5120];
            while ((len = inBuff.read(b)) != -1) {
                ((BufferedOutputStream)outBuff).write(b, 0, len);
            }
            ((BufferedOutputStream)outBuff).flush();
        }
        finally {
            if (inBuff != null) {
                inBuff.close();
            }
            if (outBuff != null) {
                outBuff.close();
            }
        }
    }

    public static void copyDirectiory(String sourceDir, String targetDir) throws IOException {
        new File(targetDir).mkdirs();
        File[] file = new File(sourceDir).listFiles();
        for (int i = 0; i < file.length; ++i) {
            if (file[i].isFile()) {
                File sourceFile = file[i];
                File targetFile = new File(new File(targetDir).getAbsolutePath() + File.separator + file[i].getName());
                FileHelper.copyFile(sourceFile, targetFile);
            }
            if (!file[i].isDirectory()) continue;
            String dir1 = sourceDir + "/" + file[i].getName();
            String dir2 = targetDir + "/" + file[i].getName();
            FileHelper.copyDirectiory(dir1, dir2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File srcFileName, File destFileName, String srcCoding, String destCoding) throws IOException {
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(srcFileName), srcCoding));
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destFileName), destCoding));
            char[] cbuf = new char[5120];
            int len = cbuf.length;
            int off = 0;
            int ret = 0;
            while ((ret = br.read(cbuf, off, len)) > 0) {
                off += ret;
                len -= ret;
            }
            bw.write(cbuf, 0, off);
            bw.flush();
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (bw != null) {
                bw.close();
            }
        }
    }

    public static void del(String filepath) throws IOException {
        File f = new File(filepath);
        if (f.exists() && f.isDirectory()) {
            if (f.listFiles().length == 0) {
                f.delete();
            } else {
                File[] delFile = f.listFiles();
                int i = f.listFiles().length;
                for (int j = 0; j < i; ++j) {
                    if (delFile[j].isDirectory()) {
                        FileHelper.del(delFile[j].getAbsolutePath());
                    }
                    delFile[j].delete();
                }
            }
        }
    }
}

